# CommentCustomField
#
# Release 0.01 (Aug 14, 2009)
# Release 0.02 (Aug 17, 2009) add Image Upload.
# Release 0.03 (Sep 10, 2009) fix bug.
#
# This software is provided as-is. You may use it for commercial or
# personal use. If you distribute it, please keep this notice intact.
#
# Copyright (c) 2004-2009 Yujiro Araki

package MT::Plugin::CommentCustomField;

use strict;
use warnings;
use CGI;
use MT;
use base qw( MT::Plugin );
use MT::Template;
use File::Basename;
use MT::Util qw( remove_html multi_iter encode_js is_valid_email is_url encode_url decode_url epoch2ts ts2epoch format_ts dirify encode_html );

our $VERSION = '0.03';
our $SCHEMA_VERSION = '0.2';

my $plugin = __PACKAGE__->new ({
    id   => 'commentcustomfield',
    name => 'CommentCustomField',
    description => '<MT_TRANS phrase="CommentCustomField.">',
    doc_link => 'http://www.koikikukan.com/archives/2009/08/14-025555.php',
    author_name => 'Yujiro Araki',
    author_link => 'http://www.koikikukan.com/',
    l10n_class => 'CommentCustomField::L10N',
    blog_config_template => 'blog_config.tmpl',
    settings => new MT::PluginSettings([
        ['use_comment_customfield_text', { Default => 1 }],
        ['use_comment_customfield_textarea', { Default => 0 }],
        ['comment_image_upload_path', { Default => '' }],
        ['comment_image_max_size', { Default => '300' }],
        ['comment_image_add_timestamp', { Default => '1' }],
    ]),
    version => $VERSION,
    schema_version => $SCHEMA_VERSION,
});
MT->add_plugin($plugin);

sub instance { $plugin }

sub init_registry {
    my $plugin = shift;
    $plugin->registry({
        object_types => {
            'comment' => {
                'custom_text' => 'string(255)',
                'custom_textarea' => 'text',
                'custom_image' => 'integer',
            },
        },
        callbacks => {
            'MT::App::CMS::template_param.edit_comment' => \&edit_comment_customfield,
            'MT::Comment::pre_save' => \&save_comment_customfield,
        },
        tags => {
            function => {
                'CommentCustomFieldText' => \&comment_customfield_text,
                'CommentCustomFieldTextarea' => \&comment_customfield_textarea,
                'PreviewCommentCustomFieldText' => \&preview_comment_customfield_text,
                'PreviewCommentCustomFieldTextarea' => \&preview_comment_customfield_textarea,
            },
            block => {
                'CommentCustomFieldAsset' => \&comment_customfield_asset,
            },
        },
    });
}

sub save_comment_customfield {
    my ($eh, $comment) = @_;

    my $app = MT->instance;
    return if (!$app->can('param')); 

    if ($app->{query}->param('comment-custom-text')) {
        $comment->custom_text($app->{query}->param('comment-custom-text'));
    }

    if ($app->{query}->param('comment-custom-textarea')) {
        $comment->custom_textarea($app->{query}->param('comment-custom-textarea'));
    }

    if ($app->{query}->param("comment-custom-image")) {
        my $asset = _handle_upload('comment-custom-image', require_type => 'image');
        return 1 if !$asset;
        $comment->custom_image($asset->id);
    }

    1;
}

sub comment_customfield_asset {
    my ($ctx, $args, $cond) = @_;

    my $tokens = $ctx->stash('tokens');
    my $builder = $ctx->stash('builder');

    require MT::Asset;

    my $comment = $ctx->stash('comment');
    my $id = $comment->custom_image;
    return '' unless $id;

    my $asset = MT::Asset->load($id);
    return '' unless $asset;

    my $blog = $ctx->stash('blog');
    return '' if $asset->blog_id != $blog->id;

    local $ctx->{__stash}{asset} = $asset;
    defined(my $out = $builder->build($ctx, $tokens))
        or return $ctx->error($builder->errstr);
    $out;
}

sub comment_customfield_text {
    my ($ctx, $args) = @_;

    my $comment = $ctx->stash('comment');
    if ($comment && $comment->id) {
        return $comment->custom_text;
    }
    else {
        return '';
    }
}

sub comment_customfield_textarea {
    my ($ctx, $args) = @_;

    my $comment = $ctx->stash('comment');
    if ($comment && $comment->id) {
        return $comment->custom_textarea;
    }
    else {
        return '';
    }
}

sub comment_customfield_image_url {
    my ($ctx, $args) = @_;

    my $comment = $ctx->stash('comment');
    if ($comment && $comment->id) {
        return $comment->custom_image_url;
    }
    else {
        return '';
    }
}

sub preview_comment_customfield_text {
    my ($ctx, $args) = @_;

    my $app = MT->instance;
    return $app->param('comment-custom-text');
}

sub preview_comment_customfield_textarea {
    my ($ctx, $args) = @_;

    my $app = MT->instance;
    return $app->param('comment-custom-textarea');
}

sub edit_comment_customfield {
    my ($eh, $app, $param, $tmpl) = @_;
    my ($node, $host_node, $innerHTML);

    my $use_textarea = $plugin->get_config_value('use_comment_customfield_textarea', 'blog:' . $app->blog->id);
    if ($use_textarea) {
      $node = $tmpl->createElement('app:setting');
      $node->setAttribute('id', 'comment_custom_textarea');
      $node->setAttribute('label', $plugin->translate('Comment CustomField Textarea'));
      my $comment_custom_textarea = $param->{custom_textarea};
      $innerHTML = <<HERE;
        <textarea name="comment-custom-textarea" id="comment-custom-textarea" style="width:90%">$comment_custom_textarea</textarea>
HERE
      $node->innerHTML($innerHTML);
      $host_node = $tmpl->getElementById('text');
      $tmpl->insertAfter($node, $host_node);
    }

    my $use_text = $plugin->get_config_value('use_comment_customfield_text', 'blog:' . $app->blog->id);
    if ($use_text) {
      $node = $tmpl->createElement('app:setting');
      $node->setAttribute('id', 'comment_custom_text');
      $node->setAttribute('label', $plugin->translate('Comment CustomField Textfield'));
      my $comment_custom_text = $param->{custom_text};
      $innerHTML = <<HERE;
        <input name="comment-custom-text" id="comment-custom-text" value="${comment_custom_text}" style="width:90%" />
HERE
      $node->innerHTML($innerHTML);
      $host_node = $tmpl->getElementById('text');
      $tmpl->insertAfter($node, $host_node);
    }
}

# Thanks Community.pm _handle_upload
sub _handle_upload {
    my ($param, %options) = @_;
    my $app = MT->instance;

    my ($fh, $no_upload);
    my $q = CGI->new();
    eval { $fh = $q->upload($param) };
    if ( $@ && $@ =~ /^Undefined subroutine/ ) {
        $fh = $q->param($param);
    }
    $no_upload = !$fh;
    return 0 if $no_upload;

    my $info = $q->uploadInfo($fh);
    my $mimetype;
    if ($info) {
        $mimetype = $info->{'Content-Type'};
    }

    # TCY
    my $maxsize = $plugin->get_config_value('comment_image_max_size', 'blog:' . $app->blog->id) || 300;
    my $size = (stat($fh))[7];
    return 0 if ($size > $maxsize * 1024);

    my $basename = basename($fh);

    $basename =~ s!\\!/!g;    ## Change backslashes to forward slashes
    $basename =~ s!^.*/!!;    ## Get rid of full directory paths
    if ( $basename =~ m!\.\.|\0|\|! ) {
        return $app->errtrans( "Invalid filename '[_1]'", $basename );
    }
    my ($base, $uploaded_path, $ext) = File::Basename::fileparse($basename, '\.[^\.]*');
    # dirify $base
    $base = dirify( $base );

    if ($plugin->get_config_value('comment_image_add_timestamp', 'blog:' . $app->blog->id)) {
        my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = gmtime(time);
        my $timestamp = sprintf("%04d%02d%02d%02d%02d%02d", $year + 1900, $mon +1, $mday, $hour, $min, $sec);
        $base .= '_comment' . $timestamp;
    }

    if (my $asset_type = $options{require_type}) {
        require MT::Asset;
        my $asset_pkg = MT::Asset->handler_for_file($basename);
        if ($asset_type eq 'image') {
            return $app->errtrans( "Please select an image to upload." )
              if !$asset_pkg->isa('MT::Asset::Image');
        }
    }

    my ($blog_id, $blog, $save_path, $local_path, $fmgr, %complements);

    $blog_id    = $app->blog->id;
    $save_path  = '%r'. '/' . $plugin->get_config_value('comment_image_upload_path', 'blog:' . $app->blog->id);
    $save_path .= '/' unless $save_path =~ m|/$|;
    if ($plugin->get_config_value('comment_image_upload_path', 'blog:' . $app->blog->id)) {
        $local_path = File::Spec->catdir(
                 $app->blog->site_path . '/' . $plugin->get_config_value('comment_image_upload_path', 'blog:' . $app->blog->id));
        require MT::FileMgr;
        my $fmgr = MT::FileMgr->new('Local');
        $fmgr->mkpath($local_path);
    } else {
        $local_path = File::Spec->catdir($app->blog->site_path);
    }

    require MT::FileMgr;
    $fmgr = MT::FileMgr->new('Local');
    %complements = (
        Max => ($app->config('UserpicMaxUpload') || 0),
        Square => ($options{square} || 0),
    );

    # Find unique name for the file.
    my $i = 1;
    my $base_copy = $base;
    while ($fmgr->exists(File::Spec->catfile($local_path, $base . $ext))) {
        $base = $base_copy . '_' . $i++;
    }

    my $local_relative = File::Spec->catfile($save_path, $base . $ext);
    my $local = File::Spec->catfile($local_path, $base . $ext);

    require MT::Image;
    require Carp;
    my ($w, $h, $id, $write_file) = MT::Image->check_upload(
        Fh => $fh, Fmgr => $fmgr, Local => $local,
        %complements
    );

    return $app->error(MT::Image->errstr)
        unless $write_file;
    my $umask = oct $app->config('UploadUmask');
    my $old   = umask($umask);
    defined( my $bytes = $write_file->() )
      or return $app->error(
        $app->translate(
            "Error writing upload to '[_1]': [_2]", $local,
            $fmgr->errstr
        )
      );
    umask($old);

    ## Close up the filehandle.
    close $fh;

    require MT::Asset;
    my $asset_pkg = MT::Asset->handler_for_file($local);
    my $is_image  = defined($w)
      && defined($h)
      && $asset_pkg->isa('MT::Asset::Image');
    my $asset;
    $asset = $asset_pkg->new();
    $asset->file_path($local_relative);
    $asset->file_name($base.$ext);
    my $ext_copy = $ext;
    $ext_copy =~ s/\.//;
    $asset->file_ext($ext_copy);
    $asset->blog_id($blog_id);

    my $original = $asset->clone;
    my $url = $local_relative;
    $url  =~ s!\\!/!g;
    $asset->url($url);
    if ($is_image) {
        $asset->image_width($w);
        $asset->image_height($h);
    }
    $asset->mime_type($mimetype);

    $asset->save
        or return $app->error($asset->errstr);
    $asset;
}

1;
