#!/usr/bin/perl -w

# Movable Type plugin.
# Release 0.01 (Mar 24, 2008) initial version.
# Release 0.02 (Arp 21, 2008) add category and tags.
# Copyright (c) 2004-2008 Yujiro Araki

use strict;

use CGI;
use File::Copy; 
use File::Basename;

our $q = new CGI;
our $version = '0.02';

sub BEGIN {
    my $dir;
    require File::Spec;
    if (!($dir = $ENV{MT_HOME})) {
        if ($0 =~ m!(.*[/\\])!) {
            $dir = $1;
        } else {
            $dir = './';
        }
        $ENV{MT_HOME} = $dir;
    }
    unshift @INC, File::Spec->catdir($dir, 'lib');
    unshift @INC, File::Spec->catdir($dir, 'extlib');
    unshift @INC, File::Spec->catdir($dir, 'addons/Commercial.pack/lib');
}
$|=1;

sub top {
  print $q->header(-charset=>'UTF-8'),
          $q->start_html(-lang=>'ja', -encoding=>'UTF-8', -title=>'mt-csv2customfields');
  print <<HTML;
<h1>mt-csv2customfields v$version</h1>
<form action="mt-csv2customfields.cgi" method="post" enctype="multipart/form-data">
    <input type="hidden" name="method" value="1" />
    <p>ブログのID<br /><input type="text" name="blogID" /></p>
    <p>投稿者のID<br /><input type="text" name="authorID" /></p>
    <p>CSVファイル<br /><input type="file" name="filename" /></p>
    <p>
       <input type="submit" value="送信" />
       <input type="reset" value="リセット" />
    </p>
</form>
<pre>
HTML
}

sub getPost {
    use MT;
    use MT::Entry;
    use CustomFields::Util qw( save_meta ); 

    print $q->header(-charset=>'UTF-8'),
          $q->start_html(-lang=>'ja', -encoding=>'UTF-8', -title=>'upload.cgi');
    my $path = ".";
    my $fh = $q->upload('filename');
    my $tmppath   = $q->tmpFileName($q->upload('filename'));

    my $mt = MT->new or die MT->errstr;
    open(FILE, "< $tmppath");

    print <<HTML;
<h1>ファイルアップロード中</h1>
<ul>
HTML
    my @field = ('title','text','category','tags');
    my @customfields;
    my $entry;
    my $entry_title;
    my $meta;
    my $header = 0;
    my %flag;
    my %pos;
    my @entries = MT::Entry->load( { blog_id => $q->param('blogID') } );
    while (<FILE>) {
        my @data = split(/\,/,$_);

        # only first
        if (!$header) {
            my $count = 0;
            for my $i (@data) {
                my $match = 0;
                for my $f (@field) {
                    if ($i eq $f) {
                        $flag{$f} = 1;
                        $pos{$f} = $count;
                        $match = 1;
                    }
                }
                if (!$match) {
                    $i =~ s/\s+//g;
                    push(@customfields, $i);
                }
                $count++;
            }
            $header = 1;
            next;
        }

        # get data
        my $buf = '';
        my $category_label = '';
        my $fieldcount = 0;

        $entry = MT::Entry->new;

        for my $i (0 .. $#data) {
            if ($flag{title} && $pos{title} == $i) {
                $entry->title($data[$i]);
                $entry_title = $data[$i];
                $buf .= $data[$i];
                next;
            }
            if ($flag{text} && $pos{text} == $i) {
                $entry->text($data[$i]);
#debug                $buf .= $data[$i];
                next;
            }
            if ($flag{tags} && $pos{tags} == $i) {
                my @tags = split(/:/,$data[$i]);
                $entry->tags(@tags);
#debug                $buf .= $data[$i];
                next;
            }
            if ($flag{category} && $pos{category} == $i) {
                $category_label = $data[$i];
                next;
            }
            $meta->{$customfields[$fieldcount]} = $data[$i]; 
            $fieldcount++;
#debug            $buf .= "$data[$i]";
        }

        my $is_exist = 0;

        # overwrite entry (customfield only)
        for my $e (@entries) {
            if ($e->title eq $entry->title) {
                $is_exist = 1;
                &save_meta($e, $meta);
                $e->save or die $entry->errstr;
                print "<li>[$buf]のカスタムフィールドを上書きしました. ブログ記事ID:".$e->id."</li>";
            }
        }

        # new entry
        if (!$is_exist) {
            $entry->author_id($q->param('authorID'));
            $entry->blog_id($q->param('blogID'));
            $entry->status(MT::Entry::RELEASE());
            $entry->save or die $entry->errstr;
            &save_meta($entry, $meta);
            print "<li>[$buf]を追加しました. ブログ記事ID:".$entry->id."</li>";

            my $result = add_category_to_entry($q->param('blogID'), $entry->id, $category_label,1);
            print "<li>[$buf]にカテゴリー[$category_label]を設定しました</li>" if $result;
        }
    }
    close($q->upload('filename'));
    print <<HTML;
</ul>
<p>ブログ記事の書き込みが完了しました。</p>
HTML

}

sub add_category_to_entry {
  my $blog_id = shift;
  my $entry_id = shift;
  my $category_label = shift;
  my $is_primary = shift;

  my $cat = MT::Category->load({ label => $category_label, blog_id => $blog_id });
  my $cat_id;
  if(!$cat) {
      $cat_id = create_category($blog_id, $category_label);
      print "<li>カテゴリー[$category_label]を作成しました</li>" if $cat_id;
  }

  use MT::Placement;
  my $place = MT::Placement->new;
  $place->entry_id($entry_id);
  $place->blog_id($blog_id);
  $cat ? $place->category_id($cat->id) : $place->category_id($cat_id);
  $place->is_primary($is_primary);
  $place->save
        or die $place->errstr;
  return 1;
}

sub create_category {
  my $blog_id = shift;
  my $category_label = shift;

  my $cat = MT::Category->new;
  $cat->blog_id($blog_id);
  $cat->label($category_label);
  $cat->save
    or die $cat->errstr;
  my $cat_id = $cat->id;
  return $cat_id;
}

my $method = $q->param('method');
if(!$method){
    &top;
} else {
    &getPost;
}

