# Archive Date Footer plugin for Movable Type
#
# Release 0.01 (May 12, 2008)
#
# This software is provided as-is. You may use it for commercial or
# personal use. If you distribute it, please keep this notice intact.
#
# Copyright (c) 2004-2008 Yujiro Araki

package MT::Plugin::SubCategoryDepth;
use strict;
use base qw(MT::Plugin);
use vars qw($VERSION);

use MT::Template::Context;
use MT::Util qw(get_entry);

MT::Template::Context->add_tag(SubCategoryDepth => \&_hdlr_sub_category_depth);
MT::Template::Context->add_tag(SubFolderDepth => \&_hdlr_sub_folder_depth);

BEGIN {
    $VERSION = '0.01';
    my $plugin = MT::Plugin::SubCategoryDepth->new ({
        name => 'SubCategoryDepth Plugin',
        description => 'MTSubCategoryDepth tag.',
        doc_link => 'http://www.koikikukan.com/archives/2008/05/12-022222.php',
        version => $VERSION,
        });
    MT->add_plugin ($plugin);
}

sub _hdlr_sub_category_depth {
    my ($ctx, $args) = @_;
    my $class_type = $args->{class_type} || 'category';
    my $class = MT->model($class_type);
    my $entry_class = MT->model(
        $class_type eq 'category' ? 'entry' : 'page');
  
    # Make sure were in the right context
    # mostly to see if we have anything to actually build
    my $tokens = $ctx->stash('subCatTokens') 
        or return $ctx->error(
            MT->translate("[_1] used outside of [_2]",
              $class_type eq 'category'
              ? (qw(MTSubCategoryDepth MTSubCategories))
              : (qw(MTSubFolderDepth MTSubFolders))
            )
        );
  
    # Get the depth info
    $ctx->stash('subCatsDepth') || 0;
}

sub _hdlr_sub_folder_depth {
    my($ctx, $args, $cond) = @_;

    require MT::Folder;
    $args->{class_type} = MT::Folder->properties->{class_type};
    _hdlr_sub_category_depth($ctx, $args, $cond);
}
