package MT::Plugin::InsertAssetWithoutStyle;
use strict;

use base qw( MT::Plugin );

require MT::Plugin;
require MT;

my $plugin = MT::Plugin::InsertAssetWithoutStyle->new({
    'name' => 'InsertAssetWithoutStyle',
    'author_name' => 'Yujiro Araki',
    'author_link' => 'http://www.koikikukan.com/',
    'description' => 'Insert asset without style.',
    'version' => '0.02',
});
MT->add_plugin($plugin);

sub init_registry {
    my $plugin = shift;
    $plugin->registry({
        callbacks => {
            'MT::App::CMS::template_source.asset_options_image'
                => \&asset_options_image,
        },
   });
}

sub asset_options_image {
    my ($cb, $app, $template) = @_;
    my $old = <<HERE;
    <input type="radio" name="align" id="align-left" class="rb" value="left" <mt:if name="align_left">checked="checked" </mt:if>/>
HERE

    $old = quotemeta($old);
    my $new = <<HERE;
    <link rel="stylesheet" href="<mt:var name="static_uri">plugins/InsertAssetWithoutStyle/styles/app.css" type="text/css" />
    <input type="radio" name="align" id="align-none" class="rb" value="none" <mt:unless name="align_left"><mt:unless name="align_center"><mt:unless name="align_right">checked="checked" </mt:unless></mt:unless></mt:unless>/>
    <label class="icon-none icon-none-xwide icon-align icon-align-none"><__trans phrase="None"></label>

    <input type="radio" name="align" id="align-left" class="rb" value="left" <mt:if name="align_left">checked="checked" </mt:if>/>
HERE

    $$template =~ s/$old/$new/;
}

1;
