package RebuildOrderChanger::CMS;

use strict;
use warnings;

sub set_param {
    my ($cb, $app, $param, $tmpl) = @_;

    1;
}

sub add_js {
    my ($cb, $app, $template) = @_;

    my $plugin = MT->component('RebuildOrderChanger');
    my $index = $plugin->translate('index');
    my $Individual = $plugin->translate('Individual');
    my $Page = $plugin->translate('Page');
    my $Daily = $plugin->translate('Daily');
    my $Weekly = $plugin->translate('Weekly');
    my $Monthly = $plugin->translate('Monthly');
    my $Yearly = $plugin->translate('Yearly');
    my $Author = $plugin->translate('Author');
    my $AuthorDaily = $plugin->translate('Author-Daily');
    my $AuthorWeekly = $plugin->translate('Author-Weekly');
    my $AuthorMonthly = $plugin->translate('Author-Monthly');
    my $AuthorYearly = $plugin->translate('Author-Yearly');
    my $Category = $plugin->translate('Category');
    my $CategoryDaily = $plugin->translate('Category-Daily');
    my $CategoryWeekly = $plugin->translate('Category-Weekly');
    my $CategoryMonthly = $plugin->translate('Category-Monthly');
    my $CategoryYearly = $plugin->translate('Category-Yearly');

    my $old;
    my $new;

    $old = <<HTML;
  <mtapp:setting
     id="dbtype"
     label="<__trans phrase="_REBUILD_PUBLISH">"
     label_class="top-label">
    <select name="type" class="full">
      <option value="<mt:var name="build_order">" selected="selected"><__trans phrase="All Files"></option>
    <mt:if name="index_tmpl_id">
      <option value="index-<mt:var name="index_tmpl_id">" selected="selected"><__trans phrase="Index Template: [_1]" params="<mt:var name="index_tmpl_name" escape="html" escape="html">"></option>
    </mt:if>
      <option value="index"<mt:if name="index_selected"> selected="selected"</mt:if>><__trans phrase="Only Indexes"></option>
    <mt:loop name="archive_type_loop">
      <option value="<mt:var name="archive_type">"><__trans phrase="Only [_1] Archives" params="<mt:var name="archive_type_label" escape="html">"></option>
    </mt:loop>
    <mt:loop name="rebuild_option_loop">
      <option value="<mt:var name="key">"><mt:var name="label" escape="html"></option>
    </mt:loop>
    </select>
  </mtapp:setting>
HTML
    $old = quotemeta($old);

my $check = $plugin->translate('check');
my $uncheck = $plugin->translate('uncheck');

    $new = <<HTML;
<link rel="stylesheet" href="<mt:var name="static_uri">plugins/RebuildOrderChanger/css/jquery-ui.css">
<style>
#sortable {
    list-style-type: none;
    margin: 0;
    padding: 0;
    width: 174px;
}
#sortable li {
    list-style-type: none;
    margin: 0 3px 3px 0;
    padding: 0.4em;
    padding-left: 1.5em;
    font-size: 12px;
    height: 16px;
    cursor: move;
}
#sortable li span {
    position: absolute;
    margin-left: -1.3em;
}
a {
    text-decoration: none;
}
</style>
<mtapp:setting
     id="dbtype"
     label_class="top-label">
<div style="margin: 5px 0">
<a href="javascript:void(0)" id="check"/>$check</a> / <a href="javascript:void(0)" id="uncheck"/>$uncheck</a>
</div>
<ul id="sortable">
<mt:GetVar name="build_order" split="," setvar="order">
<mt:loop name="order">
<mt:if name="__value__" eq="index">
<mt:var name="text" value="$index">
<mt:elseif name="__value__" eq="Individual">
<mt:var name="text" value="$Individual">
<mt:elseif name="__value__" eq="Page">
<mt:var name="text" value="$Page">
<mt:elseif name="__value__" eq="Daily">
<mt:var name="text" value="$Daily">
<mt:elseif name="__value__" eq="Weekly">
<mt:var name="text" value="$Weekly">
<mt:elseif name="__value__" eq="Monthly">
<mt:var name="text" value="$Monthly">
<mt:elseif name="__value__" eq="Yearly">
<mt:var name="text" value="$Yearly">
<mt:elseif name="__value__" eq="Author">
<mt:var name="text" value="$Author">
<mt:elseif name="__value__" eq="Author-Daily">
<mt:var name="text" value="$AuthorDaily">
<mt:elseif name="__value__" eq="Author-Weekly">
<mt:var name="text" value="$AuthorWeekly">
<mt:elseif name="__value__" eq="Author-Monthly">
<mt:var name="text" value="$AuthorMonthly">
<mt:elseif name="__value__" eq="Author-Yearly">
<mt:var name="text" value="$AuthorYearly">
<mt:elseif name="__value__" eq="Category">
<mt:var name="text" value="$Category">
<mt:elseif name="__value__" eq="Category-Daily">
<mt:var name="text" value="$CategoryDaily">
<mt:elseif name="__value__" eq="Category-Weekly">
<mt:var name="text" value="$CategoryWeekly">
<mt:elseif name="__value__" eq="Category-Monthly">
<mt:var name="text" value="$CategoryMonthly">
<mt:elseif name="__value__" eq="Category-Yearly">
<mt:var name="text" value="$CategoryYearly">
</mt:if>
<li class="ui-state-default"><span class="ui-icon ui-icon-arrowthick-2-n-s"></span><input type="checkbox" id="<mt:GetVar name="__value__">" name="<mt:GetVar name="__value__">" /> <label for="<mt:GetVar name="__value__">"><mt:var name="text"></label></li>
</mt:loop>
</ul>
<input type="hidden" name="type" />
</mtapp:setting>

<mt:setvarblock name="jq_js_include" append="1">
jQuery('#sortable').sortable();
jQuery('#sortable').disableSelection();

var list = new Array();
jQuery('button.publish').click(function(){
    jQuery('#sortable input').each(function(){
        if (jQuery(this).is(':checked')) {
            list.push(jQuery(this).attr('id'));
        }
    });
    jQuery("input[name=type]").val(list.join(","));
});
jQuery('#check').click(function(){
    jQuery('#sortable input').each(function(){
        jQuery(this).attr("checked", true);
    });
});
jQuery('#uncheck').click(function(){
    jQuery('#sortable input').each(function(){
        jQuery(this).attr("checked", false);
    });
});
</mt:setvarblock>
HTML
    $$template =~ s/$old/$new/;

        $old = <<HERE;
HERE

    $old = quotemeta($old);
    $new = <<HERE;
HERE
    $$template =~ s!$old!$new!;

    $old = <<HERE;
HERE

    $old = quotemeta($old);
    $new = <<HERE;
HERE
    $$template =~ s!$old!$new!;
}

1;
